#delimit ;

/* this program displays the results for Table 2 */


cap prog drop display_results ;
prog def display_results ;
syntax  , [results_data(string) numstates_list(string)] ;

cap log close table4_out.csv ;
cap log close t4out ;
qui log using table4_out.csv , text replace name(t4out) ;
qui log off t4out  ;

foreach ss in `numstates_list' { ;

	drop _all ;
	use `results_data' if numstates == `ss' ;
	
	gen dof_nmk = numobs - K ;
	gen dof_gm1 = numstates - 1 ;
	gen dof_gm2 = numstates - 2 ;
	
	gen p_def_Tnk = 2 * ttail(dof_nmk,(abs(b - 0) / se_def)) ;
	gen p_clu_Tnk = 2 * ttail(dof_nmk,(abs(b - 0) / se_clu)) ;
	gen p_clu_Tg1 = 2 * ttail(dof_gm1,(abs(b - 0) / se_clu)) ;
	gen p_clu_Tg2 = 2 * ttail(dof_gm2,(abs(b - 0) / se_clu)) ;
	gen p_bsse_Tg1 = 2 * ttail(dof_gm1,(abs(b - 0) / se_clu_bs)) ;

	qui gen rej = . ;
	foreach mthd in def_Tnk clu_Tnk clu_Tg1 clu_Tg2 bsse_Tg1 pairs_bs rad_res webb_res { ;
		qui replace rej = (p_`mthd' < 0.05) ;
		qui summ rej ;
		local rej_rate_`mthd' = r(mean) ;
	} ;
	
	qui summ numbsreps ;
	local mc_reps = r(N) ;
	local bs_reps = r(mean) ;
	
	qui summ bs_misreps_b ;
	local bs_missed_b = r(mean) ;
	
	qui summ bs_misreps_t ;
	local bs_missed_t = r(mean) ;
	
	qui log on t4out  ;
	di ;
	di ;
	di "Num Clusters," _column(25) %6s "`ss'" ;
	di ;
	foreach mthd in def_Tnk clu_Tnk clu_Tg1 clu_Tg2 bsse_Tg1 pairs_bs rad_res webb_res { ;
		di "Rej. rate `mthd',"	_column(35) %6.3f `rej_rate_`mthd'' ;
	} ;
	di ;
	di ;
	di "Number MC replications," _column(35) %6.0f `mc_reps' ;
	di "Number BS replications," _column(35) %6.0f `bs_reps' ;
	di "Number missed pairs BS - beta," _column(35) %6.0f `bs_missed_b' ;
	di "Number missed pairs BS - tstats," _column(35) %6.0f `bs_missed_t' ;
	di ;
	di "-----------------------------------------" ;
	di ;

	qui log off t4out ;
	
} ; /* end foreach ss in `numstates_list' { */

qui log close t4out ;

end ;
